require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Trapping"

-----------------------------------------------------------------
-- Helper: format percent with one decimal place and a '%' suffix
-- @param n number
-- @return string like "10.5%"
-----------------------------------------------------------------
local function _fmtPct1(n)
    local v = tonumber(n) or 0
    -- one decimal place always (10.5)
    local asStr = string.format("%.1f", v)
    return asStr .. "%"
end

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel() or 0

    -- ~1.5% catch bonus per Trapping level (snapshot at placement)
    local catchBonusPct = lvl * 1.5
    local catchBonusStr = _fmtPct1(catchBonusPct)

    -- Header for this block
    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))

    -- "+X% Catch Chance"
    ctx.add(ST.getText("IGUI_DST_Trapping_val_CatchChance", catchBonusStr))

    -- Past ~mid skill, you meaningfully roll better animals
    if lvl >= 4 then
        ctx.addSeparator()
        ctx.add(ST.getText("IGUI_DST_Trapping_val_RareGame"), { color = ST.COLORS.greyedout })
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)